<?php

/**
 * helper class that paginates records on admin panel pages
 * it lists of page numbers to allow users to view a specific page with one click.
 * it also allows users to determine how many records will be shown by a drop-down on a page.
 */
class Paginator {
    var $items_per_page;
    var $items_total;
    var $current_page;
    var $num_pages;

    /**
     * the number of page buttons in the middle of the pagination bar
     * ie: <<Previous 1 ...6 7 8 9 [10] 11 12 13 14 ... 18 Next>> 
     *     when click on page 10 if $mid_range = 9
     */
    var $mid_range;
    var $low;
    var $high;
    var $limit;
    
    /**
     * the HTML code for the pagination bar
     */
    var $return;
    var $default_ipp = ITEMS_PER_PAGE_DEFAULT;
    
    /**
     * prefix for the common pagination form input such as items_per_page, page_select
     * to support multiple pagination on one page
     */
	var $prefix;
	
    function Paginator($prefix)
    {
    	$this->prefix = $prefix;
    	if(!isset($_POST[$this->prefix.'items_per_page'])) {
    		$_POST[$this->prefix.'items_per_page'] = $this->default_ipp;
    	}
    	if(!isset($_POST[$this->prefix.'page_on_bar'])) {
    		$_POST[$this->prefix.'page_on_bar'] = 1;
    	}
    	if(!isset($_POST[$this->prefix.'page_select'])) {
    		$_POST[$this->prefix.'page_select'] = 1;
    	}
    	
        $this->mid_range = REPORT_PAGE_MID_RANGE;
        $this->items_per_page = (!empty($_POST[$this->prefix.'items_per_page'])) ? $_POST[$this->prefix.'items_per_page']:$this->default_ipp;
    }

    /**
     * generates and assigns the HTML code for a pagination bar that contains a previous page, 
     * a last page, a first page, a last page buttons and page buttons in the middle to $return.
     */
    function paginate()
    {
        if($_POST[$this->prefix.'items_per_page'] == 'All')
        {
            $this->num_pages = ceil($this->items_total/$this->default_ipp);
            $this->items_per_page = $this->default_ipp;
        }
        else
        {
            if(!is_numeric($this->items_per_page) OR $this->items_per_page <= 0) $this->items_per_page = $this->default_ipp;
            $this->num_pages = ceil($this->items_total/$this->items_per_page);
        }
        
        if($this->current_page < 1 Or !is_numeric($this->current_page)) $this->current_page = 1;
        if($this->current_page > $this->num_pages) $this->current_page = $this->num_pages;
        $prev_page = $this->current_page-1;
        $next_page = $this->current_page+1;
        
        if($this->num_pages == 1) {
        	$this->return = '';
        }
        else if($this->num_pages > 10)
        {
            $this->return = ($this->current_page != 1 And $this->items_total >= 10) ? "<a class=\"paginate\" href=\"javascript:submitPaginationForm($prev_page, '', $this->items_per_page, '$this->prefix')\"> Previous</a> ":"<span class=\"inactive\" href=\"#\"> Previous</span> ";

            $this->start_range = $this->current_page - floor($this->mid_range/2);
            $this->end_range = $this->current_page + floor($this->mid_range/2);

            if($this->start_range <= 0)
            {
                $this->end_range += abs($this->start_range)+1;
                $this->start_range = 1;
            }
            if($this->end_range > $this->num_pages)
            {
                $this->start_range -= $this->end_range-$this->num_pages;
                $this->end_range = $this->num_pages;
            }
            $this->range = range($this->start_range,$this->end_range);

            for($i=1;$i<=$this->num_pages;$i++)
            {
                if($this->range[0] > 2 And $i == $this->range[0]) $this->return .= " ... ";
                // loop through all pages. if first, last, or in range, display
                if($i==1 Or $i==$this->num_pages Or in_array($i,$this->range))
                {
                	$this->return .= ($i == $this->current_page And $_POST[$this->prefix.'page_on_bar'] != 'All') ? "<a title=\"Go to page $i of $this->num_pages\" class=\"current\" href=\"javascript:submitPaginationForm($i, '', $this->items_per_page, '$this->prefix')\">$i</a> ":"<a class=\"paginate\" title=\"Go to page $i of $this->num_pages\" href=\"javascript:submitPaginationForm($i, '', $this->items_per_page, '$this->prefix')\">$i</a> ";
                }
                if($this->range[$this->mid_range-1] < $this->num_pages-1 And $i == $this->range[$this->mid_range-1]) $this->return .= " ... ";
            }
            $this->return .= (($this->current_page != $this->num_pages And $this->items_total >= 10) And ($_POST[$this->prefix.'page_on_bar'] != 'All')) ? "<a class=\"paginate\" href=\"javascript:submitPaginationForm($next_page, '', $this->items_per_page, '$this->prefix')\">Next </a>\n":"<span class=\"inactive\" href=\"#\"> Next</span>\n";
        }
        else
        {
            for($i=1;$i<=$this->num_pages;$i++)
            {
                $this->return .= ($i == $this->current_page) ? "<a class=\"current\" href=\"#\">$i</a> ":"<a class=\"paginate\" href=\"javascript:submitPaginationForm($i, '', $this->items_per_page, '$this->prefix')\">$i</a> ";
            }
        }
        $this->low = ($this->current_page-1) * $this->items_per_page;
        $this->high = ($_POST[$this->prefix.'items_per_page'] == 'All') ? $this->items_total:($this->current_page * $this->items_per_page)-1;
        $this->limit = ($_POST[$this->prefix.'items_per_page'] == 'All') ? "":" LIMIT $this->low,$this->items_per_page";
    }

    /**
     * returns the HTML code for the drop-down that allows user to select how many records/items
     * to show in the table on one page
     * @return string
     */
    function display_items_per_page()
    {
    	if($this->items_total <= ITEMS_PER_PAGE_DEFAULT) {
    		return '';
    	}
    	else {
	        $items = '';
	        $ipp_array = array(ITEMS_PER_PAGE_DEFAULT, REPORT_LOGS_PER_PAGE_COUNT_25, REPORT_LOGS_PER_PAGE_COUNT_50, REPORT_LOGS_PER_PAGE_COUNT_100);
	        foreach($ipp_array as $ipp_opt)    $items .= ($ipp_opt == $this->items_per_page) ? "<option selected value=\"$ipp_opt\">$ipp_opt</option>\n":"<option value=\"$ipp_opt\">$ipp_opt</option>\n";
	        return "<label class = \"hidden_context\">records per page selector</label><span class=\"paginate\">Records per page </span><select class=\"paginate\" onchange=\"javascript:submitPaginationForm(1, 1, this.value, '$this->prefix');\">$items</select>\n";
    	}
    }
    
    function display_jump_menu()
    {
    	if($this->num_pages == 1) {
    		return '';
    	}
    	else {
	    	$label = "<label class = \"hidden_context\">Page Selector</label><span class=\"paginate\">Page ";
	    	$end_text = "of $this->num_pages</span>";
	    	$options = '';
	    	for($i=1;$i<=$this->num_pages;$i++)
	    	{
	    		$options .= ($i==$this->current_page) ? "<option value=\"$i\" selected>$i</option>\n":"<option value=\"$i\">$i</option>\n";
	    	}
	    
	    	return $label . "<select id=\"" . $this->prefix . "page_select\" class=\"paginate\" onchange=\"javascript:submitPaginationForm('', this.value, " . $this->items_per_page . ", '" . $this->prefix . "')\">" . $options . "</select> " . $end_text;
	    }
    }
    
    /**
     * returns the HTML code for the Page Selecting Buttons
     * @return string
     */
    function display_pages()
    {
    	if($this->return != '') {
    		return "<label class = \"hidden_context\">Page Selecting Buttons</label>" . $this->return;
    	}
        else {
        	return '';
        }
    }
    
    function display_result_num() 
    {
    	if(isset($this->items_total) && $this->items_total !== 1) { 
    		return "<span class=\"paginate\">" . $this->items_total . " results</span>";
    	}
    	else {
    		return "<span class=\"paginate\">" . $this->items_total . " result</span>";
    	}
    }

    /**
     * returns the entire pagination bar
     * @return string
     */
    function display_pagination_bar()
    {
    	$bar = '<div class=\'pagination\'>';
    	$bar .= $this->display_result_num();
    	$bar .= '<span>&nbsp;&nbsp;&nbsp;&nbsp;';
    	$bar .= $this->display_pages() . "</span>";
    	$bar .= '<span>&nbsp;&nbsp;&nbsp;&nbsp;';
    	$bar .= $this->display_items_per_page() . "</span>";
    	$bar .= '<div style = \'float:right; position:relative\'>';
    	$bar .= $this->display_jump_menu() . '</div></div>';
    	
    	return $bar;
    }
    
    /**
     * process form input for pagination
     * @param unknown_type $bar_page
     * @param unknown_type $jump_page
     * @param unknown_type $items_per_page
     * @param unknown_type $destination_page
     */
    function page_setup(&$bar_page, &$jump_page, &$items_per_page, &$destination_page) 
    {
    	$bar_page = $_POST[$this->prefix.'page_on_bar'];
		$jump_page = $_POST[$this->prefix.'page_select'];
		if(isset($_POST['prefix']) && $this->prefix == $_POST['prefix']) {
			$jump_page = $_POST['page_select_correction'];
		}
		
		if(!isset($items_per_page)) {
			
			if(!empty($_POST[$this->prefix.'items_per_page']) && $_POST[$this->prefix.'items_per_page'] != 0) {
				$items_per_page = $_POST[$this->prefix.'items_per_page'];
			}
			else {
				$items_per_page = $this->default_ipp;
			}
		}
		
		if(!isset($destination_page)) {
			if(isset($bar_page) && !empty($bar_page)) {
				$destination_page = $bar_page;
			}
			else if(isset($jump_page) && !empty($jump_page)) {
				$destination_page = $jump_page;
			}
			else {
				$destination_page = 1;
			}
    	}
    	$this->items_per_page = $items_per_page;
		$this->current_page = $destination_page;
    }
}
?>
